//%attributes = {}
// ----------------------------------------------------
// User name (OS): imac1
// Date and time: 17.10.08, 17:00:01
// ----------------------------------------------------
// Method: _mb4d_METHOD_LIST_GET
// Description
// 
//
// Parameters
// ----------------------------------------------------

//*==============================================================================
//Project method : svn_getMethodList
// Public
//
//DESCRIPTION :
// This method loads into arrays the method names and their CC4D ids
// for a given structure
//
//PARAMETERS :
//  $1 (POINTER) => array text pointer for method names (object modified)
//  $2 (POINTER) => array longint pointer for method IDs (object modified)
//  $3 (INTEGER) => 4D structure file reference returned by svn__API_ResFile_Open
//   (optionnal, default current structure)
//  $4 (STRING) => 4D resource type (optionnal, default "TP4D")
//  
//NOTES : 
//
//EXAMPLE D'APPEL : 
//  svn_getMethodList
//  
//CREATION : Bruno LEGAY - 29/08/06, 19:52:32 - v1.00.00
//*===============================================================================

C_POINTER:C301($1)  //method names array pointer
C_POINTER:C301($2)  //method IDs array pointer
C_LONGINT:C283($3)  //4D structure file reference
_O_C_STRING:C293(4; $4)  //4D resource type

C_POINTER:C301($_mb4d_pMethodNameArrayPtr)  //method names array pointer
C_POINTER:C301($_mb4d_pMethodCC4DIdArrayPtr)  //method IDs array pointer
C_LONGINT:C283($_mb4d_ldocRef)  //4D structure file reference
_O_C_STRING:C293(4; $_mb4d_tresType)  //4D resource type

C_LONGINT:C283($_mb4d_lParam)
_O_C_STRING:C293(40; $_mb4d_tMethodName)
C_LONGINT:C283($_mb4d_lResID; $i; $_mb4d_lErr; $_mb4d_lRecordLength; $_mb4d_lCount; $_mb4d_lStart; $_mb4d_loffset; $_mb4d_lCC4DIdOffset; $_mb4d_lnewSize)
C_BLOB:C604($_mb4d_xTP4DBlob; $_mb4d_xTP4D_rsrc_Blob)

ARRAY TEXT:C222($_mb4d_atMethodName; 0)
ARRAY LONGINT:C221($_mb4d_atMethodCC4DId; 0)

$_mb4d_lParam:=Count parameters:C259
If ($_mb4d_lParam>1)  //We need at least two parameters
	
	$_mb4d_pMethodNameArrayPtr:=$1
	$_mb4d_pMethodCC4DIdArrayPtr:=$2
	
	//Checking that the pointers are of the correct type
	If ((Type:C295($_mb4d_pMethodNameArrayPtr->)=Text array:K8:16) & (Type:C295($_mb4d_pMethodCC4DIdArrayPtr->)=LongInt array:K8:19))
		
		If (False:C215)
			_O_ARRAY STRING:C218(31; $_mb4d_asMethodName; 0)
			ARRAY INTEGER:C220($_mb4d_aiMethodId; 0)
			
			//API Get Method Names ($_mb4d_asMethodName;$_mb4d_aiMethodId)  //will chash in v11
			
			_arr COPY(->$_mb4d_asMethodName; $_mb4d_pMethodNameArrayPtr; 31)
			_arr COPY(->$_mb4d_aiMethodId; $_mb4d_pMethodCC4DIdArrayPtr)
			
		Else 
			//Handling default values for $3 and $4
			Case of 
				: ($_mb4d_lParam=2)
					$_mb4d_ldocRef:=-1
					$_mb4d_tresType:="TP4D"
					
				: ($_mb4d_lParam=3)
					$_mb4d_ldocRef:=$3
					$_mb4d_tresType:="TP4D"
					
				Else 
					//: ($_mb4d_lParam=4)
					$_mb4d_ldocRef:=$3
					$_mb4d_tresType:=$4
			End case 
			
			//_mz_svn__debug (Current method name+" $_mb4d_ldocRef = "+String($_mb4d_ldocRef))
			
			//We are checking that the 4D structure file reference looks ok (opened)
			$vb_fileOpenOk:=($_mb4d_ldocRef#0)
			
			If ($vb_fileOpenOk)
				
				$_mb4d_lRecordLength:=44
				$_mb4d_lResID:=0
				
				//_mz_svn__debug (Current method name+" calling API_Resource_Get with resType = "+_mz_TXT_Enclose ($_mb4d_tresType)+", index = "+_mz_TXT_Enclose ($_mb4d_tresType)+" and docRef = "+String($_mb4d_ldocRef))
				
				//Get the list of methods and their IDs
				//$_mb4d_lErr:=API Get Resource ($_mb4d_tresType;0;$_mb4d_xTP4DBlob;$_mb4d_ldocRef)
				SET BLOB SIZE:C606($_mb4d_xTP4D_rsrc_Blob; 0)
				
				$_mb4d_lErr:=_mb4d_ResourceGet($_mb4d_tresType; 0; ->$_mb4d_xTP4D_rsrc_Blob)
				
				$_mb4d_xTP4DBlob:=$_mb4d_xTP4D_rsrc_Blob
				SET BLOB SIZE:C606($_mb4d_xTP4D_rsrc_Blob; 0)
				
				If ($_mb4d_lErr=0)
					
					//API PAck demo database: 4D_GetMethodNames
					//   Added code by Thomas S. for compatibility with 4D v11 SQL
					If (Num:C11(Application version:C493)>=1100)
						DELETE FROM BLOB:C560($_mb4d_xTP4DBlob; 0; 8)
						$_mb4d_lRecordLength:=76
					End if 
					
					//a method name record is composed of 44 bytes.
					//the first 32 bytes are the method name (31 character pascal string)
					//Then we have, from offset 32, two bytes for the CC4D ID (in native byte ordering)
					
					//Get the number of methods
					$_mb4d_lCount:=BLOB size:C605($_mb4d_xTP4DBlob)\$_mb4d_lRecordLength
					
					ARRAY TEXT:C222($_mb4d_atMethodName; $_mb4d_lCount)
					ARRAY LONGINT:C221($_mb4d_atMethodCC4DId; $_mb4d_lCount)
					
					$_mb4d_lStart:=0
					For ($i; 1; $_mb4d_lCount)  //Loop for each method name
						
						//Get the current method name
						$_mb4d_loffset:=$_mb4d_lStart
						$_mb4d_tCurrentMethodName:=BLOB to text:C555($_mb4d_xTP4DBlob; Mac Pascal string:K22:8; $_mb4d_loffset)
						
						//Get the CC4D ID
						$_mb4d_lCC4DIdOffset:=$_mb4d_lStart+32
						//$_mb4d_lCC4DId:=API Get Method ID ($_mb4d_tCurrentMethodName)`v11, same as next BLOB to integer
						$_mb4d_lCC4DId:=BLOB to integer:C549($_mb4d_xTP4DBlob; Native byte ordering:K22:1; $_mb4d_lCC4DIdOffset)
						
						$_mb4d_atMethodName{$i}:=$_mb4d_tCurrentMethodName
						$_mb4d_atMethodCC4DId{$i}:=$_mb4d_lCC4DId
						
						$_mb4d_lStart:=$_mb4d_lStart+$_mb4d_lRecordLength
					End for 
					
					//sorting the arrays (names and ids) by method name
					SORT ARRAY:C229($_mb4d_atMethodName; $_mb4d_atMethodCC4DId; >)
					
					//copy the local arrays into the arrays given in the parameters
					COPY ARRAY:C226($_mb4d_atMethodName; $_mb4d_pMethodNameArrayPtr->)
					COPY ARRAY:C226($_mb4d_atMethodCC4DId; $_mb4d_pMethodCC4DIdArrayPtr->)
					
					//free ou local arrays
					ARRAY TEXT:C222($_mb4d_atMethodName; 0)
					ARRAY LONGINT:C221($_mb4d_atMethodCC4DId; 0)
					
				Else 
					_info_ ALERT(Current method name:C684+" error "+String:C10($_mb4d_lErr)+" calling API Get Resource \""+$_mb4d_tresType+"\" !")
				End if 
				
				//If (($_mb4d_lParam<3)&$vb_fileOpenOk)`We did open the file so we will close it
				//API_ResFile_Close ($_mb4d_ldocRef)
				//End if 
				
			Else   //$_mb4d_tresType = 0, there is a problem with the file reference 
				_info_ ALERT(Current method name:C684+" error "+String:C10($_mb4d_lErr)+" opening resource file !")
			End if 
			
		End if 
		
	Else   //not of the expected type
		_info_ ALERT(Current method name:C684+" error with $1 and/or $2 paramters !")
	End if 
	
Else 
	_info_ ALERT(Current method name:C684+" : not enough parameters.")
End if 
